import os
import re

def main():
    try:
        os.mkdir(os.path.expandvars('$ISISROOT/src/qisis/tsts/SquishTests/output'))
    except Exception:
        pass
    try:
        os.unlink(os.path.expandvars('$ISISROOT/src/qisis/tsts/SquishTests/output/') + 'GroundWithoutRadiusSourceOutput.net')
    except Exception:
        pass
    
    startApplication("qnet")
    
    # Open cube list
    activateItem(waitForObjectItem(":qnet_QMenuBar", "File"))
    activateItem(waitForObjectItem(":qnet.File_QMenu", "Open control network and cube list"))
    snooze(0.5)
    mouseClick(waitForObject(":fileNameEdit_QLineEdit"), 95, 13, 0, Qt.LeftButton)
    type(waitForObject(":fileNameEdit_QLineEdit"), "../src/qisis/tsts/SquishTests/input/Ground/Extracted_AllOverlaps.lis")
    type(waitForObject(":_QListView"), "<Return>")

    # Open control net
    snooze(0.5)
    mouseClick(waitForObject(":fileNameEdit_QLineEdit_7"), 38, 13, 0, Qt.LeftButton)
    waitForObjectItem(":stackedWidget.treeView_QTreeView_2", "Mini\\.net")
    doubleClickItem(":stackedWidget.treeView_QTreeView_2", "Mini\\.net", 58, 5, 0, Qt.LeftButton)
    
    # Open ground source file
    activateItem(waitForObjectItem(":qnet_QMenuBar", "File"))
    activateItem(waitForObjectItem(":qnet.File_QMenu", "Open Ground Source"))
    clickButton(waitForObject(":Open ground source.toParentButton_QToolButton"))
    snooze(0.5)
    mouseClick(waitForObject(":fileNameEdit_QLineEdit_2"), 95, 13, 0, Qt.LeftButton)
    type(waitForObject(":fileNameEdit_QLineEdit_2"), "src/qisis/tsts/SquishTests/input/Ground/Shade_Mola_Radius.cub")
    type(waitForObject(":fileNameEdit_QLineEdit_2"), "<Return>")
    waitForObjectItem(":Navigator_List", "I01812006RDR\\_bndry\\_6\\_LUPA")
    doubleClickItem(":Navigator_List", "I01812006RDR\\_bndry\\_6\\_LUPA", 109, 2, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Register_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":QnetToolScroll.Right Measure_QGroupBox"), 161, 15, 0, Qt.LeftButton)
    mouseClick(waitForObject(":Right Measure_QComboBox"), 148, 5, 0, Qt.LeftButton)
    clickButton(waitForObject(":Left Measure.Edit Lock Measure_QCheckBox"))
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.OK_QPushButton"))
    clickButton(waitForObject(":Right Measure.Edit Lock Measure_QCheckBox"))
    scrollTo(waitForObject(":QnetToolScroll_QScrollBar"), 598)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.OK_QPushButton"))

    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))

    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":VP2"), 164, 160, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.No_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":Left Measure_QComboBox"), 145, 5, 0, Qt.LeftButton)
    mouseClick(waitForObject(":Left Measure_QComboBox"), 145, 5, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Add Measure(s) to Point_QPushButton"))
    clickButton(waitForObject(":Add Measures to ControlPoint.OK_QPushButton"))
    mouseClick(waitForObject(":Left Measure_QComboBox"), 364, 4, 0, Qt.LeftButton)
    mouseClick(waitForObjectItem(":Left Measure_QComboBox", "f684a63\\.lev1\\_slo\\.cub"), 259, 4, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Register_QPushButton"))
    clickButton(waitForObject(":Error.OK_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":Left Measure_QComboBox"), 106, 14, 0, Qt.LeftButton)
    mouseClick(waitForObjectItem(":Left Measure_QComboBox", "I02536005RDR\\.cub"), 88, 6, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":Left Measure_QComboBox"), 250, 0, 0, Qt.LeftButton)
    mouseClick(waitForObjectItem(":Left Measure_QComboBox", "I01812006RDR\\.cub"), 195, 2, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.No_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":VP2"), 139, 152, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"))
    sendEvent("QMouseEvent", waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"), QEvent.MouseButtonPress, 55, 10, Qt.LeftButton, 1, 0)
    sendEvent("QMouseEvent", waitForObject(":Qnet Tool Save Measure.Yes_QPushButton"), QEvent.MouseButtonRelease, 111, 12, Qt.LeftButton, 0, 0)
    clickButton(waitForObject(":Qnet Tool Save Measure.No_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    sendEvent("QCloseEvent", waitForObject(":Qnet Tool"))
    sendEvent("QCloseEvent", waitForObject(":_QMainWindow"))
    mouseClick(waitForObject(":Control Network Navigator_QComboBox"), 105, 17, 0, Qt.LeftButton)
    mouseClick(waitForObjectItem(":Control Network Navigator_QComboBox", "Cubes"), 60, 5, 0, Qt.LeftButton)
    waitForObjectItem(":Navigator_List", "I18337016RDR\\.cub")
    clickItem(":Navigator_List", "I18337016RDR\\.cub", 120, 4, 0, Qt.LeftButton)
    sendEvent("QWheelEvent", waitForObject(":Navigator_List"), 117, 169, -120, 0, 2)
    sendEvent("QWheelEvent", waitForObject(":Navigator_List"), 115, 168, -120, 0, 2)
    sendEvent("QWheelEvent", waitForObject(":Navigator_List"), 115, 168, -120, 0, 2)
    sendEvent("QWheelEvent", waitForObject(":Navigator_List"), 114, 168, -120, 0, 2)
    sendEvent("QWheelEvent", waitForObject(":Navigator_List"), 114, 167, -120, 0, 2)
    waitForObjectItem(":Navigator_List", "I27759024RDR\\.cub")
    doubleClickItem(":Navigator_List", "I27759024RDR\\.cub", 100, 6, 0, Qt.LeftButton)
    sendEvent("QMoveEvent", waitForObject(":Navigator"), 780, 792, 1226, 808)
    waitForObjectItem(":Navigator_List", "I26012038RDR\\.cub")
    doubleClickItem(":Navigator_List", "I26012038RDR\\.cub", 80, 9, 0, Qt.LeftButton)
    waitForObjectItem(":Navigator_List", "I18337016RDR\\.cub")
    doubleClickItem(":Navigator_List", "I18337016RDR\\.cub", 92, 4, 0, Qt.LeftButton)
    mouseClick(waitForObject(":qnet.viewport_QWidget_4"), 254, 251, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Register_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    mouseClick(waitForObject(":Right Measure_QComboBox"), 163, 6, 0, Qt.LeftButton)
    mouseClick(waitForObjectItem(":Right Measure_QComboBox", "I26586032RDR\\.cub"), 83, 5, 0, Qt.LeftButton)
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Register_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Measure_QPushButton"))
    clickButton(waitForObject(":QnetToolScroll.Save Point_QPushButton"))
    sendEvent("QCloseEvent", waitForObject(":Qnet Tool"))
    mouseClick(waitForObject(":qnet.viewport_QWidget_4"), 248, 316, 0, Qt.MidButton)
    clickButton(waitForObject(":Delete ControlPoint.Delete ControlPoint_QCheckBox"))
    clickButton(waitForObject(":Delete ControlPoint.OK_QPushButton"))
    sendEvent("QMouseEvent", waitForObject(":qnet.viewport_QWidget_4"), QEvent.MouseButtonPress, 251, 323, Qt.MidButton, 4, 0)
    sendEvent("QMouseEvent", waitForObject(":qnet.viewport_QWidget_4"), QEvent.MouseButtonRelease, 251, 323, Qt.MidButton, 0, 0)
    
    listItemI18337016RDR= re.sub("([._ ])", "\\\\\\1", os.path.expandvars('$ISISROOT/src/qisis/tsts/SquishTests/input/Ground/Extracted_AllOverlaps/I18337016RDR.cub'))
    listItemI06281019RDR= re.sub("([._ ])", "\\\\\\1", os.path.expandvars('$ISISROOT/src/qisis/tsts/SquishTests/input/Ground/Extracted_AllOverlaps/I06281019RDR.cub'))
    
    waitForObjectItem(":Delete ControlPoint.fileList_QListWidget",  listItemI18337016RDR)
    clickItem(":Delete ControlPoint.fileList_QListWidget", listItemI18337016RDR, 147, 8, 0, Qt.LeftButton)
    type(waitForObject(":Delete ControlPoint.fileList_QListWidget"), "<Control>")
    waitForObjectItem(":Delete ControlPoint.fileList_QListWidget", listItemI06281019RDR)
    clickItem(":Delete ControlPoint.fileList_QListWidget", listItemI06281019RDR, 135, 9, 67108864, Qt.LeftButton)
    clickButton(waitForObject(":Delete ControlPoint.OK_QPushButton"))
    clickButton(waitForObject(":Delete Reference measure?.Yes_QPushButton"))
    clickButton(waitForObject(":Error.OK_QPushButton"))
    
    # Save resulting network
    activateItem(waitForObjectItem(":qnet_QMenuBar", "File"))
    activateItem(waitForObjectItem(":qnet.File_QMenu", "Save Control Network As..."))
    clickButton(waitForObject(":Choose filename to save under.toParentButton_QToolButton"))
    snooze(0.5)
    mouseClick(waitForObject(":fileNameEdit_QLineEdit_3"), 95, 13, 0, Qt.LeftButton)
    type(waitForObject(":fileNameEdit_QLineEdit_3"), "src/qisis/tsts/SquishTests/output/GroundWithoutRadiusSourceOutput.net")
    snooze(1)
    type(waitForObject(":fileNameEdit_QLineEdit_3"), "<Return>")

    activateItem(waitForObjectItem(":qnet_QMenuBar", "File"))
    activateItem(waitForObjectItem(":qnet.File_QMenu", "Exit"))
    snooze(1)
